<?php

namespace App\Models\Cargo;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class IntegrationToken extends Model 
{

    protected $table = 'cargo_firm_integration_tokens';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('refresh_token', 'status', 'resolver', 'expired_at');
    protected $visible = array('status', 'resolver');

    public function cargoFirm()
    {
        return $this->belongsTo('App\Models\Cargo\Firm');
    }

}